class XSB extends TournamentScoreBoard;

#exec TEXTURE IMPORT NAME=XB FILE=Textures\Background.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=BlackColor FILE=Textures\BlackColor.bmp MIPS=ON
#exec TEXTURE IMPORT NAME=MHLogo FILE=Textures\MHLogo.bmp MIPS=ON

var localized string MapTitle, Author, Restart, Continue, Ended, ElapsedTime, RemainingTime, FragGoal, TimeLimit;
var localized string PlayerString, FragsString, DeathsString, PingString;
var localized string TimeString, LossString, FPHString;
var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor, BackgroundColor;
var PlayerReplicationInfo Ordered[32];
var float ScoreStart;	// top allowed score start
var bool bTimeDown;
var FontInfo MyFonts;
var localized string MapTitleQuote;
var color RankColor;
var string Ranking;

function DrawRankings(Canvas Canvas)
{
local float X,Y;
local float Ypos,AdjustY;


	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.StrLen("Test", X, Y);

	AdjustY = Y * 17 * 0.5;
	Ypos = Canvas.ClipY * 0.5 - AdjustY;

	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(1, Ypos + Y);
	Canvas.DrawText("Enlisted Personel:", True);
	//Draw Recruit
	if (Pawn(Owner).PlayerReplicationInfo.Score < 20000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 2);
	Canvas.DrawText("Recruit", True);
	//Draw Private
	if (Pawn(Owner).PlayerReplicationInfo.Score < 40000 && Pawn(Owner).PlayerReplicationInfo.Score >= 20000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 3);
	Canvas.DrawText("Private", True);
	//Draw Corporal
	if (Pawn(Owner).PlayerReplicationInfo.Score < 60000 && Pawn(Owner).PlayerReplicationInfo.Score >= 40000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 4);
	Canvas.DrawText("Corporal", True);
	//Draw Sergeant
	if (Pawn(Owner).PlayerReplicationInfo.Score < 80000 && Pawn(Owner).PlayerReplicationInfo.Score >= 60000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 5);
	Canvas.DrawText("Sergeant", True);
	//Draw Staff Sergeant
	if (Pawn(Owner).PlayerReplicationInfo.Score < 100000 && Pawn(Owner).PlayerReplicationInfo.Score >= 80000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 6);
	Canvas.DrawText("Staff Sergeant", True);
	//Draw Sergeant First Class
	if (Pawn(Owner).PlayerReplicationInfo.Score < 120000 && Pawn(Owner).PlayerReplicationInfo.Score >= 100000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 7);
	Canvas.DrawText("Sergeant First Class", True);
	//Draw Master Sergeant
	if (Pawn(Owner).PlayerReplicationInfo.Score < 150000 && Pawn(Owner).PlayerReplicationInfo.Score >= 120000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 8);
	Canvas.DrawText("Master Sergeant", True);
	//Draw Commisioned Personel
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(1, Ypos + Y * 9);
	Canvas.DrawText("Commisioned Personel:", True);
	//Draw Second Lieutenant
	if (Pawn(Owner).PlayerReplicationInfo.Score < 200000 && Pawn(Owner).PlayerReplicationInfo.Score >= 150000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 10);
	Canvas.DrawText("Second Lieutenant", True);
	//Draw First Lieutenant
	if (Pawn(Owner).PlayerReplicationInfo.Score < 400000 && Pawn(Owner).PlayerReplicationInfo.Score >= 200000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 11);
	Canvas.DrawText("First Lieutenant", True);
	//Draw Captain
	if (Pawn(Owner).PlayerReplicationInfo.Score < 800000 && Pawn(Owner).PlayerReplicationInfo.Score >= 400000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 12);
	Canvas.DrawText("Captain", True);
	//Draw Major
	if (Pawn(Owner).PlayerReplicationInfo.Score < 1200000 && Pawn(Owner).PlayerReplicationInfo.Score >= 800000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 13);
	Canvas.DrawText("Major", True);
	//Draw Colonel
	if (Pawn(Owner).PlayerReplicationInfo.Score < 1800000 && Pawn(Owner).PlayerReplicationInfo.Score >= 1200000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 14);
	Canvas.DrawText("Colonel", True);
	//Draw 1-star General
	if (Pawn(Owner).PlayerReplicationInfo.Score < 2400000 && Pawn(Owner).PlayerReplicationInfo.Score >= 1800000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 15);
	Canvas.DrawText("1-star General", True);
	//Draw 2-star General
	if (Pawn(Owner).PlayerReplicationInfo.Score < 3000000 && Pawn(Owner).PlayerReplicationInfo.Score >= 2400000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 16);
	Canvas.DrawText("2-star General", True);
	//Draw Marshal
	if (Pawn(Owner).PlayerReplicationInfo.Score >= 3000000)
		Canvas.DrawColor = RankColor;
	else
		Canvas.DrawColor = BlueColor;
	Canvas.SetPos(1, Ypos + Y * 17);
	Canvas.DrawText("Marshal", True);
}

function Destroyed()
{
	Super.Destroyed();
	if ( MyFonts != None )
		MyFonts.Destroy();
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
	MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;

	//Draw MonsterHunt Logo:
	Canvas.DrawColor = WhiteColor;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, 1);
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.DrawTile(Texture'MHLogo', 512, 128, 0, 0, 512, 128);
	Canvas.Style = Style;

	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 58.0/768.0 * Canvas.ClipY;
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, 90);
		Canvas.DrawText(GRI.GameEndedComments, True);
	}
	else
	{
		DrawVictoryConditions(Canvas);
	}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	Canvas.SetPos(0, 90);

	if ( TGRI.TimeLimit > 0 )
		Canvas.DrawText("TimeLimit: "@TGRI.TimeLimit$":00"$" minutes.");
}

function string TwoDigitString(int Num)
{
	if ( Num < 10 )
		return "0"$Num;
	else
		return string(Num);
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	if ( (Level.NetMode == NM_Standalone) && Level.Game.IsA('DeathMatchPlus') )
	{
		if ( DeathMatchPlus(Level.Game).bRatedGame )
			Canvas.DrawText(DeathMatchPlus(Level.Game).RatedGameLadderObj.SkillText@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else if ( DeathMatchPlus(Level.Game).bNoviceMode ) 
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
		else  
			Canvas.DrawText(class'ChallengeBotInfo'.default.Skills[Level.Game.Difficulty + 4]@PlayerOwner.GameReplicationInfo.GameName@MapTitle@MapTitleQuote$Level.Title$MapTitleQuote, true);
	}
	else
		Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);

	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawCategoryHeaders(Canvas Canvas)
{
	// no need to draw them anymore :)
}

function SetRank(int Score)
{
	// Enlisted:
	if ( Score < 20000 )
		Ranking = "Recruit";
	else if ( Score < 40000 )
		Ranking = "Private";
	else if ( Score < 60000 )
		Ranking = "Corporal";
	else if ( Score < 80000 )
		Ranking = "Sergeant";
	else if ( Score < 100000 )
		Ranking = "Staff Sergeant";
	else if ( Score < 120000 )
		Ranking = "Sergeant First Class";
	else if ( Score < 150000 )
		Ranking = "Master Sergeant";
	// Commissioned:
	else if ( Score < 200000 )
		Ranking = "Second Lieutenant";
	else if ( Score < 400000 )
		Ranking = "First Lieutenant";
	else if ( Score < 800000 )
		Ranking = "Captain";
	else if ( Score < 1200000 )
		Ranking = "Major";
	else if ( Score < 1800000 )
		Ranking = "Colonel";
	else if ( Score < 2400000 )
		Ranking = "1-star General";
	else if ( Score < 3000000 )
		Ranking = "2-star General";
	else
		Ranking = "Marshal";
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, XL3, YL3;
	local Font CanvasFont;
	local bool bLocalPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;

	PlayerOwner = PlayerPawn(Owner);

	bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	//Draw Frame:
	Canvas.DrawColor = WhiteColor;
	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, YOffset);
	Canvas.DrawTile(Texture'BlackColor', 512, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, YOffset + 33);
	Canvas.DrawTile(Texture'BlackColor', 512, 1, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 - 256, YOffset + 1);
	Canvas.DrawTile(Texture'BlackColor', 1, 32, 0, 0, 4, 4);
	Canvas.SetPos(Canvas.ClipX * 0.5 + 255, YOffset + 1);
	Canvas.DrawTile(Texture'BlackColor', 1, 32, 0, 0, 4, 4);
	//Draw background:
	Canvas.DrawColor = BackgroundColor;
	Canvas.Style = ERenderStyle.STY_Translucent;
	Canvas.SetPos(Canvas.ClipX * 0.5 - 255, YOffset + 1);
	Canvas.DrawTile(Texture'XB', 510, 32, 0, 0, 4, 4);
	//Draw Player Face:
	if ( PRI.TalkTexture != None )
		{
		Canvas.DrawColor = WhiteColor;
		Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.SetPos(Canvas.ClipX * 0.5 - 254, YOffset + 2);
		Canvas.DrawTile(PRI.TalkTexture, 30, 30, 0, 0, 64, 64);
		}

	Canvas.Style = ERenderStyle.STY_Normal;
	// Draw Name
	if ( PRI.bAdmin )
		Canvas.DrawColor = WhiteColor;
	else if ( bLocalPlayer ) 
		Canvas.DrawColor = GoldColor;
	else 
		Canvas.DrawColor = CyanColor;

	Canvas.SetPos(Canvas.ClipX * 0.5 - 222, YOffset + 1);
	Canvas.DrawText(PRI.PlayerName, False);

	Canvas.StrLen( "0000", XL, YL );

	// Draw Score
	if ( !bLocalPlayer )
		Canvas.DrawColor = LightCyanColor;

	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);

	Canvas.SetPos( Canvas.ClipX * 0.5 + 96, YOffset + 1 );
	Canvas.DrawText("Score: "@int(PRI.Score), false );

	// Draw Deaths
	if ( PRI.Deaths > 0 )
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 + 96, YOffset + 17 );
		Canvas.DrawText("Lives : "@int(PRI.Deaths), false );
		}
	else
		{
		Canvas.SetPos( Canvas.ClipX * 0.5 + 96, YOffset + 17 );
		Canvas.DrawText("Out of match.", false );
		}
	
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetAReallySmallFont(Canvas.ClipX);

	// Draw Time
	Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 222, YOffset + 22 );
	Canvas.DrawText( "Time: "@Time, false );

	// Draw Ranking
	SetRank(PRI.Score);
	Canvas.SetPos( Canvas.ClipX * 0.5 - 110, YOffset + 22 );
	Canvas.DrawText( "Rank: "@Ranking, false );

	XL3 = FMax(XL3, XL2);
	// Draw Ping
	Canvas.SetPos( Canvas.ClipX * 0.5 - 165, YOffset + 22 );
	Canvas.DrawText( "Ping: "@PRI.Ping, false );

	
	
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;
	
	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
	local float XL, YL, Scale;
	local float YOffset, YStart;
	local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	// Header
	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);

	Canvas.SetPos(0, 160.0/768.0 * Canvas.ClipY);
	DrawCategoryHeaders(Canvas);

	Canvas.StrLen( "TEST", XL, YL );
	YStart = 128;
	YOffset = YStart;
	if ( PlayerCount > 15 )
		PlayerCount = FMin(PlayerCount, (Canvas.ClipY - YStart)/YL - 1);

	Canvas.SetPos(0, 0);
	for ( I=0; I<PlayerCount; I++ )
	{
		YOffset = YStart + I * 35;
		DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	// Trailer
	if ( !Level.bLowRes )
	{
		Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
		DrawTrailer(Canvas);
	}
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = CanvasFont;

	DrawRankings(Canvas);
}

defaultproperties
{
     MapTitle="in"
     Author="by"
     Restart="You are dead.  Hit [Fire] to respawn!"
     Continue=" Hit [Fire] to continue!"
     Ended="The hunt has ended."
     GreenColor=(G=255)
     WhiteColor=(R=255,G=255,B=255)
     GoldColor=(R=255,G=255)
     BlueColor=(B=255)
     LightCyanColor=(R=128,G=255,B=255)
     SilverColor=(R=138,G=164,B=166)
     BronzeColor=(R=203,G=147,B=52)
     CyanColor=(G=128,B=255)
     RedColor=(R=255)
     BackgroundColor=(R=50,G=50,B=50)
     RankColor=(R=255,G=255)
}
